 import javafx.application.Application;
 import javafx.event.ActionEvent;
 import javafx.scene.Scene;
 import javafx.scene.control.*;
 import javafx.scene.layout.Pane;
 import javafx.stage.Stage;
 public class ExpandedDollarMealMenu extends Application 
 {
    MenuItem saladItem, chickenSoupItem, hamburgerItem, bltItem, 
             tacoItem, nachoItem, chiliItem;
   
    @Override
    public void start(Stage primaryStage) 
    {
       //1- Create the menu bar, which is an instance of the class 
       MenuBar aMenuBar = new MenuBar();
       //2- Create the menus and their submenus 
       Menu dollarMenu = new Menu("Dollar");
       Menu extrasMenu = new Menu("Extras");
       Menu sandwichMenu = new Menu("Sandwich");
       Menu mexicanMenu = new Menu("Mexican");
       //3-Create menu items and sub-menu items. Register event handlers
       saladItem = new MenuItem("Salad");
       chickenSoupItem = new MenuItem("Chicken Soup");
       hamburgerItem = new MenuItem("Hamburger");
       bltItem = new MenuItem("BLT");
       tacoItem = new MenuItem("Taco");
       nachoItem = new MenuItem("Nacho");
       chiliItem = new MenuItem("Chili");
       saladItem.setOnAction(e-> dollarMenuItemHandler(e));
       chickenSoupItem.setOnAction(e-> dollarMenuItemHandler(e));
       hamburgerItem.setOnAction(e-> dollarMenuItemHandler(e));
       bltItem.setOnAction(e-> dollarMenuItemHandler(e));
       tacoItem.setOnAction(e-> dollarMenuItemHandler(e));
       nachoItem.setOnAction(e-> dollarMenuItemHandler(e));
       chiliItem.setOnAction(e-> dollarMenuItemHandler(e));
   
       //4- Add items to the submenus and items and submenus to the menus
       SeparatorMenuItem seperator1 = new SeparatorMenuItem();
       SeparatorMenuItem seperator2 = new SeparatorMenuItem();
       sandwichMenu.getItems().addAll(hamburgerItem, bltItem);
       mexicanMenu.getItems().addAll(tacoItem, nachoItem, chiliItem);
       dollarMenu.getItems().addAll(saladItem, chickenSoupItem,seperator1,
                                   sandwichMenu, seperator2, mexicanMenu);

       //5- Add the menus to the menu bar
       aMenuBar.getMenus().addAll(dollarMenu, extrasMenu);
       //6- Add the menu bar to the pane container
       Pane pane = new Pane();
       pane.getChildren().addAll(aMenuBar);
       
       Scene scene = new Scene(pane, 350, 200);
       
       primaryStage.setTitle("Expanded Dollar Meal Menu");
       primaryStage.setScene(scene);
       primaryStage.show();
    }  

    public static void main(String[] args) 
    {
       launch(args);
    }
 
    public void dollarMenuItemHandler(ActionEvent e)
    {
       String order = "You ordered ";

       if(e.getSource() == saladItem) 
       { 
          order = order + "a Salad"; 
       }
       else if(e.getSource() == chickenSoupItem) 
       {
          order = order + "Chicken Soup";
       }
       else if(e.getSource() == bltItem) 
       {
          order = order + "a BLT Sandwich";
       }
       else if(e.getSource() == hamburgerItem)
       {
          order = order + "a Hamburger";
       }
       else if(e.getSource() == tacoItem) 
       }
          order = order + "a Taco";
       }
       else if(e.getSource() == nachoItem) 
       {  
          order = order + "a Nacho";  
       }
       else if(e.getSource() == chiliItem) 
       {  
          order = order + "Chili";  
       }
        
       System.out.println(order);
    }   
  }
